/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.ai;

import dev.toma.gunsrpg.common.IShootProps;
import dev.toma.gunsrpg.common.entity.ZombieGunnerEntity;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.item.guns.util.IEntityTrackingGun;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.properties.Properties;
import dev.toma.gunsrpg.util.properties.PropertyContext;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class GunAttackGoal
extends Goal {
    protected static final int[] ATTACK_RANGE_TABLE = new int[]{10, 15, 20, 25, 25, 10, 10, 15, 25};
    protected final ZombieGunnerEntity entity;
    private final IShootProps props;
    private IShootingHandler handler;

    public GunAttackGoal(ZombieGunnerEntity gunner) {
        this.entity = gunner;
        this.props = new GunnerProjectileProperties(gunner);
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        if (!this.hasGun() || !this.entity.isLoaded()) {
            return false;
        }
        return this.entity.func_70638_az() != null;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.entity.func_70661_as().func_75500_f() || this.hasGun();
    }

    public void func_75249_e() {
        this.assignHandler();
        this.handler.reset();
    }

    public void func_75251_c() {
        this.handler.reset();
        this.handler = null;
    }

    public void func_75246_d() {
        LivingEntity target = this.entity.func_70638_az();
        if (target == null || !this.hasGun()) {
            return;
        }
        double dist = Math.sqrt(this.entity.func_70068_e((Entity)target));
        ItemStack stack = this.entity.func_184614_ca();
        GunItem gun = (GunItem)stack.func_77973_b();
        double attackRange = ATTACK_RANGE_TABLE[gun.getWeaponCategory().ordinal()];
        boolean canSee = this.canSeeEntity(target);
        if (dist <= attackRange && canSee) {
            this.entity.func_70661_as().func_75499_g();
        } else {
            this.entity.func_70661_as().func_75497_a((Entity)target, 1.0);
        }
        this.entity.func_70625_a((Entity)target, 30.0f, 30.0f);
        this.entity.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
        if (canSee && dist < attackRange * 3.0 && this.handler.isReadyForShooting() && !this.entity.field_70170_p.field_72995_K && this.handler.tryShootingTick()) {
            SoundEvent event = gun.getWeaponShootSound((LivingEntity)this.entity);
            gun.shoot(this.entity.field_70170_p, (LivingEntity)this.entity, stack, this.props, event);
            this.handler.reset();
        }
    }

    private void assignHandler() {
        this.handler = this.entity.getBurstDelay() == 0 ? new MagazineBasedHandler(this.entity) : new BurstShootingHandler(this.entity);
    }

    private boolean hasGun() {
        return this.entity.func_184614_ca().func_77973_b() instanceof GunItem;
    }

    private boolean canSeeEntity(LivingEntity target) {
        World world = this.entity.field_70170_p;
        BlockRayTraceResult result = ModUtils.raytraceBlocksIgnoreGlass(new Vector3d(this.entity.func_226277_ct_(), this.entity.func_226278_cu_() + (double)this.entity.func_70047_e(), this.entity.func_226281_cx_()), new Vector3d(target.func_226277_ct_(), target.func_226278_cu_() + (double)target.func_70047_e(), target.func_226281_cx_()), (IBlockReader)world);
        if (result == null || result.func_216346_c() == RayTraceResult.Type.MISS) {
            return true;
        }
        BlockPos pos = result.func_216350_a();
        BlockState state = world.func_180495_p(pos);
        VoxelShape shape = state.func_196952_d((IBlockReader)world, pos);
        if (shape.func_197766_b()) {
            return true;
        }
        return state.func_185904_a().func_76222_j() || state.func_185904_a() == Material.field_151592_s;
    }

    @FunctionalInterface
    private static interface IntSupplier {
        public int getInt();
    }

    private static class BurstShootingHandler
    extends MagazineBasedHandler {
        private final IntSupplier burstDelayTotal = entity::getBurstDelay;
        private final IntSupplier burstSize = entity::getBurstSize;
        private int actualDelay;
        private int shotsFired;

        public BurstShootingHandler(ZombieGunnerEntity entity) {
            super(entity);
        }

        @Override
        protected void finishReloading() {
            super.finishReloading();
            this.shotsFired = 0;
        }

        @Override
        protected boolean doShooting() {
            if (this.actualDelay > 0) {
                --this.actualDelay;
                this.shotsFired = 0;
                return false;
            }
            ++this.shotsFired;
            if (this.shotsFired >= this.burstSize.getInt()) {
                this.actualDelay = this.burstDelayTotal.getInt();
            }
            return super.doShooting();
        }
    }

    private static class MagazineBasedHandler
    implements IShootingHandler {
        private final IntSupplier magCapacity = entity::getMagCapacity;
        private final IntSupplier reloadCycleLength = entity::getReloadTime;
        private final IntSupplier firerate;
        private int ammoLeft = this.magCapacity.getInt();
        private int reloadTime;
        private int fireDelay;

        public MagazineBasedHandler(ZombieGunnerEntity entity) {
            this.firerate = entity::getFirerate;
        }

        @Override
        public boolean isReadyForShooting() {
            return true;
        }

        @Override
        public void reset() {
            this.fireDelay = this.firerate.getInt();
        }

        @Override
        public boolean tryShootingTick() {
            this.tickReloading();
            if (this.ammoLeft > 0) {
                if (this.fireDelay <= 0) {
                    return this.doShooting();
                }
                --this.fireDelay;
            } else {
                this.startReloading();
            }
            return false;
        }

        protected boolean doShooting() {
            --this.ammoLeft;
            return true;
        }

        protected void tickReloading() {
            if (this.reloadTime > 0) {
                --this.reloadTime;
                if (this.reloadTime == 0) {
                    this.finishReloading();
                }
            }
        }

        protected void startReloading() {
            if (this.isReloading()) {
                return;
            }
            this.reloadTime = this.reloadCycleLength.getInt();
        }

        protected void finishReloading() {
            this.ammoLeft = this.magCapacity.getInt();
        }

        protected boolean isReloading() {
            return this.reloadTime > 0;
        }
    }

    private static interface IShootingHandler {
        public boolean isReadyForShooting();

        public boolean tryShootingTick();

        public void reset();
    }

    private static class GunnerProjectileProperties
    implements IShootProps {
        private final ZombieGunnerEntity entity;

        public GunnerProjectileProperties(ZombieGunnerEntity entity) {
            this.entity = entity;
        }

        @Override
        public float getDamageMultiplier() {
            return this.entity.getDamageMultiplier();
        }

        @Override
        public float getInaccuracy() {
            return this.entity.getInaccuracy();
        }

        @Override
        public PropertyContext getExtraData() {
            ItemStack stack = this.entity.func_184614_ca();
            LivingEntity target = this.entity.func_70638_az();
            PropertyContext context = PropertyContext.create();
            if (stack.func_77973_b() instanceof IEntityTrackingGun) {
                context.setProperty(Properties.FUELED, true);
                context.setProperty(Properties.ENTITY_ID, target.func_145782_y());
                context.setProperty(Properties.GUIDENANCE, target.func_233570_aj_() ? IEntityTrackingGun.GuidenanceProperties.GUNNER_GROUND : IEntityTrackingGun.GuidenanceProperties.GUNNER_AIR);
                return context;
            }
            return PropertyContext.empty();
        }
    }
}

